// // // // // // // // // // // // // // // //
//
//	Enemy Territory - ObjectBitmap.h
//
//	erstellt 9.1.98 von Andreas Warnke
//	geändert 13.1.98 von Andreas Warnke
//



#ifndef ObjectBitmap_H_
#define ObjectBitmap_H_



// // // // // // // // // // // // // // // //
//
//	include:
//

#include "Ebene.h"
#include "FateMaker.h"



// // // // // // // // // // // // // // // //
//
//	ObjectBitmap
//

class ObjectBitmap
{
private:
	//	ObjektListe: 
	//	Typliste, deren Elemente sind Spielerlisten,
	//	deren Elemente sind ZahlListen, deren Elemente sind Bitmaps.
	static BList ObjektListe;
	//	Wabenliste:
	static BList WabenListe;
	
	//	Semaphore:
	static sem_id DieSemaphore;
	
private:
	//	Initialisierung der Waben:
	static BBitmap * WabeCreate ( int inNr );
	static void WabeDraw ( BView * inMaler, int inNr );
	static void WabeDraw2 ( BView * inMaler, int inNr );
	
	//	Initialisierung der Objekte:
	static BBitmap * ObjektCreate (
		unsigned int inTyp,
		unsigned int inOwner,
		unsigned int inZahl);
	static void ObjektDraw (
		BView * inMaler, 
		unsigned int inTyp,
		unsigned int inOwner,
		unsigned int inZahl);
	
	//	Funktionen, um Listen zu beabeiten:
	//	CreateListItem liefert true <=> ItemAt(inIndex)==NULL && existiert
	static inline bool CreateListItem ( BList & inListe, int inIndex );

public:	
	//	Zufallsgenerator:
	static FateMaker Fate;
		
public:
	//	Konstruktor:
	static void Konstruktor ();
	
	//	Destruktor:
	static void Destruktor ();
	
	//	Zeiger auf Wunsch-Bitmap:
	static BBitmap * GetBitmap (
		unsigned int inTyp,
		unsigned int inOwner,
		unsigned int inZahl);
		
	//	Zeiger auf Waben-Bitmap:
	static BBitmap * GetWabe (
		unsigned int inTyp );
		
	//	Der vollständigkeit halber:
	static void DeleteMaps ();
};



#endif



//
//	Ende.
//
// // // // // // // // // // // // // // // //